﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint;

namespace CreateListAndColumns
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            using (SPWeb web = site.OpenWeb())
            {              
               SPListCollection allLists = web.Lists;

               // Erzeuge eine neue benutzerdefinierte Liste
               Guid listGuid = allLists.Add(
                  "Bestellungen",             
                  String.Empty,                       
                  SPListTemplateType.GenericList); //Type: 100  

               SPList newList = allLists[listGuid];
               newList.OnQuickLaunch = true;

               // Hole die Collection sämtlicher Listenfelder
               SPFieldCollection fields = newList.Fields;

               // Füge ein Beschreibungsfeld hinzu
               string descriptionrField = fields.Add(
                  "Beschreibung",      // Anzeigename
                  SPFieldType.Note,    // Typ
                  false);              // Erforderlich

               // Füge ein Lookup-Feld zum Kunden hinzu
               SPList listCustomer = web.Lists.TryGetList("Kunden");
               string customerField = fields.AddLookup(
                  "Kunde",
                  listCustomer.ID,
                  true);

               // Füge eine weitere Lookup-Spalte hinzu
               SPList listArticle = web.Lists.TryGetList("Artikel");
               string articleField = fields.AddLookup(
                  "Artikel",
                  listArticle.ID,
                  false);

               // Füge eine Mengenspalte hinzu
               string amountFild = fields.Add(
                   "Menge",           
                   SPFieldType.Integer,   
                   true);             
            }
         }
      }
   }
}
